/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.commands;

import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.commands.TextEditorUtils;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.filters.AndFilter;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.scripting.model.filters.IsExecutableCommandFilter;
import com.aptana.scripting.model.filters.ScopeFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.radrails.rails.internal.ui.commands.AbstractRailsHandler;
import org.radrails.rails.ui.RailsUIPlugin;

public class PreviewCommandHandler
extends AbstractRailsHandler {
    private static final String PREVIEW_COMMAND_NAME = "Preview";
    private static final String RAILS_SCOPE = "source.ruby.rails";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<1> filters = new ArrayList<1>();
        filters.add(new IsExecutableCommandFilter(){

            public boolean include(AbstractElement element) {
                if (!super.include(element)) {
                    return false;
                }
                if (!(element instanceof CommandElement)) {
                    return false;
                }
                CommandElement node = (CommandElement)element;
                return node.getDisplayName().equals(PreviewCommandHandler.PREVIEW_COMMAND_NAME);
            }
        });
        IEditorPart textEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (textEditor instanceof ITextEditor) {
            try {
                ITextEditor abstractThemeableEditor = (ITextEditor)textEditor;
                ISourceViewer viewer = TextEditorUtils.getSourceViewer((ITextEditor)abstractThemeableEditor);
                IDocument document = abstractThemeableEditor.getDocumentProvider().getDocument((Object)abstractThemeableEditor.getEditorInput());
                int caretOffset = TextEditorUtils.getCaretOffset((ITextEditor)abstractThemeableEditor);
                String contentTypeAtOffset = null;
                contentTypeAtOffset = viewer == null ? CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset(document, caretOffset) : CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset((ITextViewer)viewer, caretOffset);
                filters.add(new ScopeFilter(contentTypeAtOffset));
            }
            catch (BadLocationException e1) {
                RailsUIPlugin.logError((Exception)((Object)e1));
            }
        } else {
            filters.add(new ScopeFilter(RAILS_SCOPE));
        }
        List commands = BundleManager.getInstance().getCommands((IModelFilter)new AndFilter(filters.toArray(new IModelFilter[filters.size()])));
        if (commands != null && !commands.isEmpty()) {
            ((CommandElement)commands.get(0)).execute();
        }
        return null;
    }
}

